MissionsTimesEvent = {};
local MissionsTimesEvent_mt = Class(MissionsTimesEvent, Event);

InitEventClass(MissionsTimesEvent, "MissionsTimesEvent");

function MissionsTimesEvent.emptyNew()
	local self = Event.new(MissionsTimesEvent_mt);
	self.className = "MissionsTimesEvent";
	return self;
end;

function MissionsTimesEvent.new(mission)
	local self = MissionsTimesEvent.emptyNew();
	self.mission = mission;	
	return self;
end;

function MissionsTimesEvent:writeStream(streamId, connection)
	--if not connection:getIsServer() then
		NetworkUtil.writeNodeObject(streamId, self.mission);		
		streamWriteInt32(streamId, self.mission.activeMissionId);
	--end;
end;

function MissionsTimesEvent:readStream(streamId, connection)
	--if connection:getIsServer() then
		self.mission = NetworkUtil.readNodeObject(streamId);		
		self.mission.activeMissionId = streamReadInt32(streamId);
	--end;

	self:run(connection);
end;

function MissionsTimesEvent:run(connection)
	if connection:getIsServer() then
		--print("####sprung MissionsTimesEvent.run, connection:getIsServer()")
		MissionsTimes:setRunningEndDate(self.mission, "MissionsTimesEvent:run connection:getIsServer");	
		g_messageCenter:publish(MissionsTimesEvent, self.mission);
		return;
	else
		--print("####sprung MissionsTimesEvent.run, NOT connection:getIsServer()")
		--MissionsTimes:setRunningEndDate(self.mission, "MissionsTimesEvent:run NOT connection:getIsServer");
	end;
end

